import {
  StateNode
} from "@tldraw/editor";
import { Idle } from "./childStates/Idle.mjs";
import { Pointing } from "./childStates/Pointing.mjs";
import { ZoomBrushing } from "./childStates/ZoomBrushing.mjs";
class ZoomTool extends StateNode {
  static id = "zoom";
  static initial = "idle";
  static children = () => [Idle, ZoomBrushing, Pointing];
  static isLockable = false;
  info = {};
  onEnter = (info) => {
    this.info = info;
    this.parent.setCurrentToolIdMask(info.onInteractionEnd);
    this.updateCursor();
  };
  onExit = () => {
    this.parent.setCurrentToolIdMask(void 0);
    this.editor.updateInstanceState({ zoomBrush: null, cursor: { type: "default", rotation: 0 } });
    this.parent.setCurrentToolIdMask(void 0);
  };
  onKeyDown = () => {
    this.updateCursor();
  };
  onKeyUp = (info) => {
    this.updateCursor();
    if (info.code === "KeyZ") {
      this.complete();
    }
  };
  onInterrupt = () => {
    this.complete();
  };
  complete() {
    if (this.info.onInteractionEnd && this.info.onInteractionEnd !== "select") {
      this.editor.setCurrentTool(this.info.onInteractionEnd, this.info);
    } else {
      this.parent.transition("select");
    }
  }
  updateCursor() {
    if (this.editor.inputs.altKey) {
      this.editor.setCursor({ type: "zoom-out", rotation: 0 });
    } else {
      this.editor.setCursor({ type: "zoom-in", rotation: 0 });
    }
  }
}
export {
  ZoomTool
};
//# sourceMappingURL=ZoomTool.mjs.map
